
<!-- header.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Shop Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .container {
            max-width: 500px;
            margin-top: 50px;
        }
    </style>
</head>
<body>

<?php
session_start();
include 'php/db_connection.php';

// শুধুমাত্র অ্যাডমিন অনুমতি পাবে
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    echo "<script>alert('আপনার অনুমতি নেই!'); window.location='manage_users.php';</script>";
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $role = $_POST['role'];

    $stmt = $con->prepare("INSERT INTO users_shop (name, email, password, role) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $name, $email, $password, $role);
    
    if ($stmt->execute()) {
        echo "<script>alert('নতুন ইউজার সফলভাবে যোগ হয়েছে!'); window.location='manage_users.php';</script>";
    } else {
        echo "<script>alert('সমস্যা হয়েছে!');</script>";
    }
}

/*----------------------------------------inclode------------------------*/
?>


<?php include 'sidebar.php'; ?>

<div class="container mt-4">
    <h2 class="text-center">নতুন ইউজার যোগ করুন</h2>
    <form method="post">
        <div class="mb-3">
            <label class="form-label">নাম</label>
            <input type="text" name="name" class="form-control" required>
        </div>
        <div class="mb-3">
            <label class="form-label">ইমেইল</label>
            <input type="email" name="email" class="form-control" required>
        </div>
        <div class="mb-3">
            <label class="form-label">পাসওয়ার্ড</label>
            <input type="password" name="password" class="form-control" required>
        </div>
        <div class="mb-3">
            <label class="form-label">ভূমিকা</label>
            <select name="role" class="form-select">
                <option value="user">User</option>
                <option value="admin">Admin</option>
            </select>
        </div>
        <button type="submit" class="btn btn-success">সংরক্ষণ করুন</button>
        <a href="manage_users.php" class="btn btn-secondary">ফিরে যান</a>
    </form>
</div>
</body>
</html>
