<!----------------------------------Login------------------------------------>
<?php
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');

?>

<!---------------------------------কন্টেন------------------------------------>
<?php
// Get sales ID from URL
$sales_id = isset($_GET['sales_id']) ? intval($_GET['sales_id']) : 0;

// Fetch sales details
$sales_query = $con->prepare("SELECT * FROM sales WHERE id = ?");
$sales_query->bind_param("i", $sales_id);
$sales_query->execute();
$sales_result = $sales_query->get_result();
$sales_data = $sales_result->fetch_assoc();

// Fetch sales items
$items_query = $con->prepare("SELECT * FROM sales_items WHERE sales_id = ?");
$items_query->bind_param("i", $sales_id);
$items_query->execute();
$items_result = $items_query->get_result();

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print Receipt</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        h1, h2, h3 {
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <h1>Sales Receipt</h1>
    <h2>Customer Information</h2>
    <p><strong>Name:</strong> <?php echo htmlspecialchars($sales_data['customer_name'], ENT_QUOTES); ?></p>
    <p><strong>Address:</strong> <?php echo htmlspecialchars($sales_data['customer_address'], ENT_QUOTES); ?></p>
    <p><strong>Deposit:</strong> <?php echo number_format($sales_data['deposit'], 2); ?></p>
    <p><strong>Discount:</strong> <?php echo number_format($sales_data['discount'], 2); ?></p>
    <h3>Sales Items</h3>
    <table>
        <tr>
            <th>Product Name</th>
            <th>Product Description</th>
            <th>Quantity</th>
            <th>Price</th>
            <th>Total</th>
        </tr>
        <?php while ($item = $items_result->fetch_assoc()): ?>
            <tr>
                <td><?php echo htmlspecialchars($item['product_id'], ENT_QUOTES); // You might want to fetch product name instead ?></td>
                <td><?php echo htmlspecialchars($item['product_description'], ENT_QUOTES); ?></td>
                <td><?php echo htmlspecialchars($item['quantity'], ENT_QUOTES); ?></td>
                <td><?php echo number_format($item['price'], 2); ?></td>
                <td><?php echo number_format($item['total'], 2); ?></td>
            </tr>
        <?php endwhile; ?>
    </table>
    <h3>Grand Total: <?php echo number_format($sales_data['grand_total'], 2); ?></h3>
    <button onclick="window.print()">Print Receipt</button>
</body>
</html>

<?php
$sales_query->close();
$items_query->close();
$con->close();
?>
